<?php
namespace Mainto\Bridge\Invokes\DataCenter\ReservationTable;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method deleteByParams(array $params)
 */
class ReservationTableBatchCloseLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  int $create_by 创建人 [Original type uint] [ require true ]
     * @support  string $date_begin 日期起 [ require true ]
     * @support  string $date_end 日期止 [ require true ]
     * @support  string $time_begin 时间起 [ require true ]
     * @support  string $time_end 时间止 [ require true ]
     * @support  int $store_id 门店id [Original type uint] [ require true ]
     * @support  array $close_list 门店id [ require true ]
     * @support  int $each_time_unset 每时段关闭数 [Original type uint] 
     * @support  string $type 记录排单类型 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  int $create_by 创建人 [Original type uint] 
     * @support  int $store_id 门店id [Original type uint] 
     * @support  string $type 排单类型 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'ReservationTable\ReservationTableBatchCloseLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'ReservationTable\ReservationTableBatchCloseLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}