<?php
namespace Mainto\Bridge\Invokes\DataCenter\PartnerHome;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createAllByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method getInfoByIdsByParams(array $params)
 * @method updateByParams(array $params)
 * @method releaseGiftsByTypeByParams(array $params)
 * @method deleteByParams(array $params)
 * @method incrementByParams(array $params)
 */
class PartnerHomeGift {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $type_id 礼物类别 [ require true ]
     * @support  array $images 图片 [ require true ]
     * @support  string $gift_name 礼物名称 [ require true ]
     * @support  string $gift_detail 礼物介绍 [ require true ]
     * @support  int $score 兑换所需 [ require true ]
     * @support  int $create_by 创建人 [ require true ]
     * @support  string $state 状态位 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 创建记录批量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAll (array $data) {
        return self::getClass()->createAll([
            "data" => $data,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  array $type_id 礼物类别 
     * @support  array $images 图片 
     * @support  string $gift_name 礼物名称 
     * @support  string $gift_detail 礼物介绍 
     * @support  int $score 兑换所需 
     * @support  string $sold 已售数量 
     * @support  array $create_by 创建人 
     * @support  string $state 状态位 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 批量获取单条详情
     *
     * @param  array $_ids _id [ require true ]
     * @param  array $fields 字段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByIds (array $_ids, array $fields = [0 => '*']) {
        return self::getClass()->getInfoByIds([
            "_ids" => $_ids,
            "fields" => $fields,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $type_id 礼物类别 
     * @support  array $images 图片 
     * @support  string $gift_name 礼物名称 
     * @support  string $gift_detail 礼物介绍 
     * @support  int $score 兑换所需 
     * @support  string $sold 已售数量 
     * @support  string $state 状态位 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 根据类型id下架礼物
     *
     * @param  string $type_id 礼物类别 [ require true ]
     * @param  string $state 状态位 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseGiftsByType (string $type_id, string $state) {
        return self::getClass()->releaseGiftsByType([
            "type_id" => $type_id,
            "state" => $state,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 自增 已解决量|未解决量
     *
     * @param  string $_id id [ require true ]
     * @param  string $column 自增字段(sold) [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function increment (string $_id, string $column = 'sold') {
        return self::getClass()->increment([
            "_id" => $_id,
            "column" => $column,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'PartnerHome\PartnerHomeGift');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'PartnerHome\PartnerHomeGift');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}