<?php
namespace Mainto\Bridge\Invokes\DataCenter\NVDActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActivityRecordByParams(array $params)
 * @method updateActivityRecordByParams(array $params)
 * @method updateBillUrlByParams(array $params)
 * @method getActivityRecordByIdByParams(array $params)
 * @method getActivityRecordByUserIdByParams(array $params)
 * @method deleteActivityRecordByIdOrUserIdByParams(array $params)
 * @method getActivityRecordListByParams(array $params)
 * @method getActivityRecordsByParams(array $params)
 * @method createVoteRecordByParams(array $params)
 * @method getVoteRecordListByParams(array $params)
 * @method syncActivityRankAndWriteToDbByParams(array $params)
 */
class NVDActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动记录
     *
     * @support  int $userId 报名用户id [ require true ]
     * @support  string $name 姓名或昵称 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $photoId 图片唯一id [ require true ]
     * @support  string $photoUrl 图片路径 [ require true ]
     * @support  string $loveConfession 爱情宣言 [ require true ]
     * @support  string $billUrl 海报地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActivityRecord () {
        return self::getClass()->createActivityRecord();
    }

    /**
     * 更新活动记录
     *
     * @support  int $userId 报名用户id [ require true ]
     * @support  int $pollNum 投票数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateActivityRecord () {
        return self::getClass()->updateActivityRecord();
    }

    /**
     * 更新海报数据
     *
     * @support  int $userId 报名用户id [ require true ]
     * @support  string $billUrl 海报url [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateBillUrl () {
        return self::getClass()->updateBillUrl();
    }

    /**
     * 通过活动id获取活动记录
     *
     * @support  string $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityRecordById () {
        return self::getClass()->getActivityRecordById();
    }

    /**
     * 通过用户id获取活动记录
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityRecordByUserId () {
        return self::getClass()->getActivityRecordByUserId();
    }

    /**
     * 按id或用户id删除记录
     *
     * @support  string $activityId 活动id 
     * @support  int $userId 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteActivityRecordByIdOrUserId () {
        return self::getClass()->deleteActivityRecordByIdOrUserId();
    }

    /**
     * 活动记录列表
     *
     * @support  bool $sortDescByPollNum 是否按票数倒序 
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityRecordList () {
        return self::getClass()->getActivityRecordList();
    }

    /**
     * 活动记录列表.不分页
     *
     * @support  bool $sortAscBySort 是否按报名顺序顺序 
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActivityRecords () {
        return self::getClass()->getActivityRecords();
    }

    /**
     * 创建活动投票记录
     *
     * @support  int $userId 报名用户id [ require true ]
     * @support  int $friendUserId 投票用户id [ require true ]
     * @support  string $activityId 报名id [ require true ]
     * @support  string $ip 投票用户ip [ require true ]
     * @support  string $date 投票日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createVoteRecord () {
        return self::getClass()->createVoteRecord();
    }

    /**
     * 用户好友投票记录列表
     *
     * @support  int $userId 报名用户id 
     * @support  string $activityId 报名id 
     * @support  int $friendUserId 投票用户id [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @support  string $date 投票日期 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVoteRecordList () {
        return self::getClass()->getVoteRecordList();
    }

    /**
     * 2月1日-2月19日, 每天3点执行, 1月份做测试调试使用
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncActivityRankAndWriteToDb () {
        return self::getClass()->syncActivityRankAndWriteToDb();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'NVDActivity\NVDActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'NVDActivity\NVDActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}