<?php
namespace Mainto\Bridge\Invokes\DataCenter\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class BusinessReservationInfo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建预约信息
     *
     * @support  string $company_name 企业名称 [ require true ]
     * @support  string $reservation_name 预约人姓名 [ require true ]
     * @support  string $reservation_phone 预约人手机号 [ require true ]
     * @support  string $reservation_email 预约人邮箱 
     * @support  array $reservation_city 预约城市 [ require true ]
     * @support  string $shoot_num 拍摄数量 
     * @support  string $product_name 产品名称 
     * @support  string $demand_brief 需求简述 
     * @support  bool $status 是否已读 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 预约信息查询
     *
     * @support  array $_ids _id组 
     * @support  bool $status 是否已读 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * 更新预约信息
     *
     * @param  string $_id 预约信息_id [ require true ]
     * @support  string $company_name 企业名称 
     * @support  string $reservation_name 预约人姓名 
     * @support  string $reservation_phone 预约人手机号 
     * @support  string $reservation_email 预约人邮箱 
     * @support  array $reservation_city 预约城市 
     * @support  string $shoot_num 拍摄数量 
     * @support  string $product_name 产品名称 
     * @support  string $demand_brief 需求简述 
     * @support  bool $status 是否已读 
     * @throws  \Exception
     * @return  array
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除预约信息
     *
     * @param  string $_id 预约信息_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Business\BusinessReservationInfo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Business\BusinessReservationInfo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}