<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method searchByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getModelByParams(array $params)
 */
class RentalLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加
     *
     * @param  int $store_id 门店编号 [ require true ]
     * @support  float $money 总金额 [Original type unsignedDouble] [ require true ]
     * @support  string $pay_time 最晚支付时间 [ require true ]
     * @support  string $image 缴费单图片地址 [ require true ]
     * @support  array $fixed_rent 固定租金 
     * @support  array $property 物业费 
     * @support  array $promotion 推广费 
     * @support  array $more 其他费用 
     * @support  string $state 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $store_id) {
        return self::getClass()->create([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 批量添加[&#039;data&#039; =&gt; [[&#039;store_id&#039; =&gt; 1001,..., &#039;fixed_rent&#039; =&gt; [&#039;money&#039; =&gt; 100, &#039;limitStart&#039; =&gt; &#039;2019-03-03&#039;, &#039;limitEnd&#039; =&gt; &#039;2019-07-09&#039;]]]]
     *
     * @param  array $data 批量插入缴费记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data) {
        return self::getClass()->batchCreate([
            "data" => $data,
        ]);
    }

    /**
     * 查询
     *
     * @support  int $store_id 门店id 
     * @support  string $pay_time_start 打款时间开始时间 
     * @support  string $pay_time_end 打款时间结束时间 
     * @support  string $state 状态 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示时间 [ require true ]
     * @support  bool $with_contract_info 包括合同信息 
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 更新
     *
     * @param  string $_id 缴费id [ require true ]
     * @support  string $state 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 详情
     *
     * @param  string $_id 缴费id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除
     *
     * @param  string $_id 缴费id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getModel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\RentalLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\RentalLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}