<?php
namespace Mainto\Bridge\Invokes\DataCenter\Photography;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Enjoy {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $name 称呼 [ require true ]
     * @support  int $phone_number 手机号码 
     * @support  int $expect_order_time 期望预约时间 
     * @support  string $remark 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取记录列表
     *
     * @support  string $state 状态（pending-待处理 ordered-已预约, quit_order-放弃预约） 
     * @support  string $name 称呼 
     * @support  int $expect_order_time_start 期望预约时间起 
     * @support  int $expect_order_time_end 期望预约时间止 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page_size = 10, int $page = 1) {
        return self::getClass()->getList([
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id _id [ require true ]
     * @support  string $state 状态（pending-待处理 ordered-已预约, quit_order-放弃预约） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Photography\Enjoy');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Photography\Enjoy');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}