<?php
namespace Mainto\Bridge\Invokes\DataCenter\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 */
class ErpActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $phone 手机号 
     * @support  string $img_path 图片路径 
     * @support  string $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取记录列表
     *
     * @support  string $phone 手机号 
     * @support  string $img_path 图片路径 
     * @support  string $activity_id 活动id 
     * @support  string $created_at_start 上传时间起 
     * @support  string $created_at_end 上传时间止 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取记录列表
     *
     * @support  string $phone 手机号 
     * @support  string $img_path 图片路径 
     * @support  string $activity_id 活动id 
     * @support  string $created_at_start 上传时间起 
     * @support  string $created_at_end 上传时间止 
     * @param  int $page_size 每页数量 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $phone 手机号 
     * @support  string $activity_id 活动id 
     * @support  string $img_path 图片路径 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Erp\ErpActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Erp\ErpActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}