<?php
namespace Mainto\Bridge\Invokes\DataCenter\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createNewYearActivityRecordByParams(array $params)
 * @method updateNewYearActivityRecordByParams(array $params)
 * @method getNewYearActivityRecordByIdByParams(array $params)
 * @method getNewYearActivityRecordByUserIdByParams(array $params)
 * @method deleteNewYearActivityRecordByIdOrUserIdByParams(array $params)
 * @method getNewYearActivityRecordListByParams(array $params)
 * @method getNewYearActivityRecordsByParams(array $params)
 * @method createNewYearVoteRecordByParams(array $params)
 * @method getNewYearVoteRecordListByParams(array $params)
 * @method syncNewYearActivityRankByParams(array $params)
 * @method syncNewYearActivityRankAndWriteToDbByParams(array $params)
 */
class NewYearActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动记录
     *
     * @support  int $user_id 报名用户id [ require true ]
     * @support  string $name 姓名或昵称 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $photo_id 图片唯一id [ require true ]
     * @support  string $photo_url 图片路径 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNewYearActivityRecord () {
        return self::getClass()->createNewYearActivityRecord();
    }

    /**
     * 更新活动记录
     *
     * @support  int $user_id 报名用户id [ require true ]
     * @support  int $poll_num 投票数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateNewYearActivityRecord () {
        return self::getClass()->updateNewYearActivityRecord();
    }

    /**
     * 通过活动id获取活动记录
     *
     * @support  string $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNewYearActivityRecordById () {
        return self::getClass()->getNewYearActivityRecordById();
    }

    /**
     * 通过用户id获取活动记录
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNewYearActivityRecordByUserId () {
        return self::getClass()->getNewYearActivityRecordByUserId();
    }

    /**
     * 按id或用户id删除记录
     *
     * @support  string $activity_id 活动id 
     * @support  int $user_id 用户id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteNewYearActivityRecordByIdOrUserId () {
        return self::getClass()->deleteNewYearActivityRecordByIdOrUserId();
    }

    /**
     * 活动记录列表
     *
     * @support  bool $sort_desc_by_poll_num 是否按票数倒序 
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNewYearActivityRecordList () {
        return self::getClass()->getNewYearActivityRecordList();
    }

    /**
     * 活动记录列表.不分页
     *
     * @support  bool $sort_desc_by_poll_num 是否按票数倒序 
     * @support  bool $sort_by_sort 是否按报名顺序顺序 
     * @support  string $name 用户名或昵称 
     * @support  string $phone 手机号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNewYearActivityRecords () {
        return self::getClass()->getNewYearActivityRecords();
    }

    /**
     * 创建活动投票记录
     *
     * @support  int $user_id 报名用户id [ require true ]
     * @support  int $friend_user_id 投票用户id [ require true ]
     * @support  string $date 投票日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNewYearVoteRecord () {
        return self::getClass()->createNewYearVoteRecord();
    }

    /**
     * 用户好友投票记录列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 分页数 
     * @support  string $date 投票日期 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNewYearVoteRecordList () {
        return self::getClass()->getNewYearVoteRecordList();
    }

    /**
     * todo 4月后功能移除，要使用需要调整, 否则会有统计问题
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncNewYearActivityRank () {
        return self::getClass()->syncNewYearActivityRank();
    }

    /**
     * 2月1日-2月19日, 每天3点执行
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncNewYearActivityRankAndWriteToDb () {
        return self::getClass()->syncNewYearActivityRankAndWriteToDb();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Activity\NewYearActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Activity\NewYearActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}