<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method getModelByParams(array $params)
 */
class AdviceFeedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加反馈
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $content 反馈内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $user_id, string $content) {
        return self::getClass()->create([
            "user_id" => $user_id,
            "content" => $content,
        ]);
    }

    /**
     * 查询
     *
     * @support  int $user_id 用户id 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * getModel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'AdviceFeedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'AdviceFeedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}