<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method searchByParams(array $params)
 * @method getModelByParams(array $params)
 */
class Exploit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $report_date 上报日期 [ require true ]
     * @support  float $report_performance 上报业绩金额 [Original type double] 
     * @support  float $report_market_performance 上报商场业绩金额 [Original type double] [ require true ]
     * @support  int $report_count 门店拍摄订单 [ require true ]
     * @support  int $system_shoot_count 上报拍摄订单 [ require true ]
     * @support  float $alipay 线下支付宝 [Original type double] [ require true ]
     * @support  float $alipay_system 支付宝【系统记录金额】 [Original type double] [ require true ]
     * @support  float $wechat 线下微信 [Original type double] [ require true ]
     * @support  float $wechat_system 微信【系统记录金额】 [Original type double] [ require true ]
     * @support  float $pos 线下刷卡 [Original type double] [ require true ]
     * @support  float $pos_system 线下刷卡【系统记录金额】 [Original type double] [ require true ]
     * @support  float $cash 线下现金 [Original type double] [ require true ]
     * @support  float $cash_system 线下现金【系统记录金额】 [Original type double] [ require true ]
     * @support  float $market_card 商场购物卡 [Original type double] [ require true ]
     * @support  float $market_card_system 商场购物卡【系统记录金额】 [Original type double] [ require true ]
     * @support  string $reason 差异原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新
     *
     * @param  string $_id 业绩id [ require true ]
     * @support  int $store_id 门店id 
     * @support  string $report_date 上报日期 
     * @support  float $report_performance 上报业绩金额 [Original type double] 
     * @support  float $report_market_performance 上报商场业绩金额 [Original type double] 
     * @support  int $report_count 门店拍摄订单 
     * @support  int $system_shoot_count 上报拍摄订单 
     * @support  float $alipay 线下支付宝 [Original type double] 
     * @support  float $alipay_system 支付宝【系统记录金额】 [Original type double] 
     * @support  float $wechat 线下微信 [Original type double] 
     * @support  float $wechat_system 微信【系统记录金额】 [Original type double] 
     * @support  float $pos 线下刷卡 [Original type double] 
     * @support  float $pos_system 线下刷卡【系统记录金额】 [Original type double] 
     * @support  float $cash 线下现金 [Original type double] 
     * @support  float $cash_system 线下现金【系统记录金额】 [Original type double] 
     * @support  float $market_card 商场购物卡 [Original type double] 
     * @support  float $market_card_system 商场购物卡【系统记录金额】 [Original type double] 
     * @support  string $reason 差异原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 查询
     *
     * @support  string $report_date_start 上报开始时间 
     * @support  string $report_date_end 上报结束时间 
     * @support  int $store_id 门店id 
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * getModel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Exploit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Exploit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}