<?php
namespace Mainto\Bridge\Invokes\DataCenter\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class BusinessReceivingAddress {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建收件人信息
     *
     * @support  int $user_id 客户id [ require true ]
     * @support  string $recipient_name 收件人姓名 [ require true ]
     * @support  string $recipient_phone 手机号 [ require true ]
     * @support  array $recipient_city 所在地区 [ require true ]
     * @support  string $recipient_address 详细地址 [ require true ]
     * @support  bool $is_default 是否默认 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 收件人查询
     *
     * @support  array $_ids _id组 
     * @support  int $user_id 客户id 
     * @support  string $recipient_name 收件人姓名 
     * @support  string $recipient_phone 手机号 
     * @support  array $recipient_city 所在地区 
     * @support  string $recipient_address 详细地址 
     * @support  bool $is_default 是否默认 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * 更新收件人信息
     *
     * @param  string $_id 预约信息_id [ require true ]
     * @support  string $recipient_name 收件人姓名 
     * @support  string $recipient_phone 手机号 
     * @support  array $recipient_city 所在地区 
     * @support  string $recipient_address 详细地址 
     * @support  bool $is_default 是否默认 
     * @throws  \Exception
     * @return  array
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除收件人信息
     *
     * @param  string $_id 预约信息_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'BusinessReceivingAddress');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'BusinessReceivingAddress');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}