<?php
namespace Mainto\Bridge\Invokes\DataCenter\HimoProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createSharePhotoAlbumRecordByParams(array $params)
 * @method saveSharePhotoAlbumByParams(array $params)
 * @method shareAlbumRecordDetailByParams(array $params)
 */
class SharePhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建相册分享记录
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $share_type 共享类型，1为普通共享，2为指定共享 [ require true ]
     * @support  array $photos 图片数据 [ require true ]
     * @support  array $white_phones 手机号白名单数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSharePhotoAlbumRecord () {
        return self::getClass()->createSharePhotoAlbumRecord();
    }

    /**
     * 创建好友共享相册
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $reserve_time 订单签到时间 [ require true ]
     * @support  string $share_record_id 分享记录id [ require true ]
     * @support  int $user_id 接受分享者id [ require true ]
     * @support  int $share_user_id 分享者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSharePhotoAlbum () {
        return self::getClass()->saveSharePhotoAlbum();
    }

    /**
     * 分享相册记录详情
     *
     * @support  string $share_record_id 分享记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function shareAlbumRecordDetail () {
        return self::getClass()->shareAlbumRecordDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'HimoProduct\SharePhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'HimoProduct\SharePhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}