<?php
namespace Mainto\Bridge\Invokes\DataCenter\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByKeyByParams(array $params)
 * @method getListByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class CommonUpyun {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $upyun_key upyun_key [ require true ]
     * @support  string $prefix 路径 [ require true ]
     * @support  string $save_key 保存key [ require true ]
     * @support  string $bucket 空间名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByKey (string $upyun_key) {
        return self::getClass()->getInfoByKey([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $bucket 空间名 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getList([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @support  string $prefix 地址前缀 
     * @support  string $save_key 保存key 
     * @support  string $bucket 空间名 
     * @support  string $path 路径 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $upyun_key) {
        return self::getClass()->update([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'CommonUpyun');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'CommonUpyun');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}