<?php
namespace Mainto\Bridge\Invokes\DataCenter\MaintoOfficial;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 */
class MaintoOfficialMediaContact {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $media_name 所属媒体 [ require true ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $email 邮箱 [ require true ]
     * @support  string $contact_phone 联系人手机号 [ require true ]
     * @support  string $contact_content 联系内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $media_name 所属媒体 [ require true ]
     * @support  string $contact_name 联系人姓名 [ require true ]
     * @support  string $email 邮箱 [ require true ]
     * @support  string $contact_phone 联系人手机号 [ require true ]
     * @support  string $contact_content 联系内容 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getList([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'MaintoOfficialMediaContact');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'MaintoOfficialMediaContact');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}