<?php
namespace Mainto\Bridge\Invokes\DataCenter\Mantu;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 */
class Feedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $all_star 总评分 
     * @support  bool $is_share 是否参与分享 
     * @support  string $note 建议 
     * @support  int $photographer 摄影师打分 
     * @support  int $makeupArtist 化妆师打分 
     * @support  int $reception 前台打分 
     * @support  int $watchmaker 看片师打分 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * search
     *
     * @param  array $order_ids 订单ids [ require true ]
     * @param  int $page 订单id [ require true ]
     * @param  int $page_size 订单id [ require true ]
     * @param  bool $with_all 全部 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (array $order_ids, int $page = 1, int $page_size = 10, bool $with_all = false) {
        return self::getClass()->search([
            "order_ids" => $order_ids,
            "page" => $page,
            "page_size" => $page_size,
            "with_all" => $with_all,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Feedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Feedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}