<?php
namespace Mainto\Bridge\Invokes\DataCenter\PartnerHome;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getCountsByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getInfoByIdsByParams(array $params)
 * @method createTypeByParams(array $params)
 * @method getTypesByParams(array $params)
 * @method getTypeInfoByParams(array $params)
 * @method updateTypeByParams(array $params)
 * @method deleteTypeByParams(array $params)
 * @method getAppraisesByParams(array $params)
 */
class PartnerHomeThink {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $state 状态位 [ require true ]
     * @support  string $type_id 点子类型 [ require true ]
     * @support  array $images 图片 
     * @support  string $recommend_reason 推荐理由 [ require true ]
     * @support  int $staff_num 用户工号 [ require true ]
     * @support  string $appraise 评选 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 按条件统计
     *
     * @support  string $type_id 点子类型 
     * @support  array $staff_num 用户工号 [Original type array&lt;uint&gt;] 
     * @support  string $state 状态位 
     * @param  string $groupBy groupBy [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCounts (string $groupBy = '') {
        return self::getClass()->getCounts([
            "groupBy" => $groupBy,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $state 状态位 
     * @support  string $type_id 类型 
     * @support  string $recommend_reason 推荐理由 
     * @support  string $un_pass_reason 未通过理由 
     * @support  array $staff_num 用户工号 [Original type array&lt;int&gt;] 
     * @support  string $created_at_start 提交时间起 
     * @support  string $created_at_end 提交时间止 
     * @support  string $is_released 是否上架 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @support  string $appraise 评选 
     * @support  bool $has_appraised 是否已评审 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  array $_ids ids [ require true ]
     * @support  string $state 状态位 
     * @support  string $type_id 类型 
     * @support  array $images 图片 
     * @support  string $recommend_reason 推荐理由 
     * @support  string $un_pass_reason 未通过理由 
     * @support  int $staff_num 用户工号 
     * @support  string $is_released 是否上架 
     * @support  string $appraise 评选 
     * @support  bool $has_appraised 是否已评审 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (array $_ids) {
        return self::getClass()->update([
            "_ids" => $_ids,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 批量获取单条详情
     *
     * @param  array $_ids _id [ require true ]
     * @param  array $fields 字段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfoByIds (array $_ids, array $fields = [0 => '*']) {
        return self::getClass()->getInfoByIds([
            "_ids" => $_ids,
            "fields" => $fields,
        ]);
    }

    /**
     * 创建类型
     *
     * @param  string $type 点子类型 [ require true ]
     * @param  int $wish_value 愿望值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createType (string $type, int $wish_value) {
        return self::getClass()->createType([
            "type" => $type,
            "wish_value" => $wish_value,
        ]);
    }

    /**
     * 获取类型列表
     *
     * @param  array $query 搜索条件 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTypes (array $query = []) {
        return self::getClass()->getTypes([
            "query" => $query,
        ]);
    }

    /**
     * 获取类型详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTypeInfo (string $_id) {
        return self::getClass()->getTypeInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新类型
     *
     * @param  string $_id 类型id [ require true ]
     * @param  string $type 愿望类型 [ require true ]
     * @param  int $wish_value 愿望值 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function updateType (string $_id, string $type, int $wish_value) {
        return self::getClass()->updateType([
            "_id" => $_id,
            "type" => $type,
            "wish_value" => $wish_value,
        ]);
    }

    /**
     * 删除类型
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteType (string $_id) {
        return self::getClass()->deleteType([
            "_id" => $_id,
        ]);
    }

    /**
     * 评选项
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAppraises () {
        return self::getClass()->getAppraises();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'PartnerHomeThink');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'PartnerHomeThink');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}