<?php
namespace Mainto\Bridge\Invokes\DataCenter\Business;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class BusinessInvoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建客户开票收货信息
     *
     * @support  int $user_id 客户id [ require true ]
     * @support  string $invoice_type 发票形式 [ require true ]
     * @support  string $invoice_type_tag 发票类型标记 [ require true ]
     * @support  string $buyername 抬头 [ require true ]
     * @support  string $taxnum 税号 [ require true ]
     * @support  string $email 收件邮箱 
     * @support  string $phone 收件人手机号 [ require true ]
     * @support  string $address 公司地址 
     * @support  string $telephone 公司电话 
     * @support  string $company_bank 公司银行 
     * @support  string $company_bank_number 银行卡号 
     * @support  string $delivery_area 所在城市 
     * @support  array $delivery_area_id 所在城市id 
     * @support  string $delivery_address 收件详细地址 
     * @support  string $delivery_people 收件人姓名 
     * @support  bool $is_default 是否默认 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 客户开票信息查询
     *
     * @support  array $_ids _id组 
     * @support  int $user_id 客户id 
     * @support  bool $is_default 是否默认 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * 更新客户开票信息
     *
     * @param  string $_id 开票信息_id [ require true ]
     * @support  string $invoice_type 发票形式 
     * @support  string $invoice_type_tag 发票类型标记 
     * @support  string $buyername 抬头 
     * @support  string $taxnum 税号 
     * @support  string $email 收件邮箱 
     * @support  string $phone 收件人手机号 
     * @support  string $address 公司地址 
     * @support  string $telephone 公司电话 
     * @support  string $company_bank 公司银行 
     * @support  string $company_bank_number 银行卡号 
     * @support  string $delivery_area 所在城市 
     * @support  array $delivery_area_id 所在城市id 
     * @support  string $delivery_address 收件详细地址 
     * @support  string $delivery_people 收件人姓名 
     * @support  bool $is_default 是否默认 
     * @throws  \Exception
     * @return  array
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除客户开票信息
     *
     * @param  string $_id 开票信息_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'BusinessInvoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'BusinessInvoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}