<?php
namespace Mainto\Bridge\Invokes\DataCenter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method contentCreateByParams(array $params)
 */
class ProductTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品模板
     *
     * @support  int $pid 产品id [ require true ]
     * @support  string $template 模板 [ require true ]
     * @support  string $slogan 标语 
     * @support  int $isShow 显示 [ require true ]
     * @support  int $sort 排序 
     * @support  int $edit 编辑 
     * @support  string $smallTemplate 小模板 
     * @support  int $maxWord 最大字数 
     * @support  int $width 宽 
     * @support  int $height 高 
     * @support  int $imgWidth 图片宽度 
     * @support  int $imgHeight 图片高度 
     * @support  int $imgToTop 到顶部 
     * @support  int $editToTop 标记到顶部 
     * @support  int $editFontSize 编辑字体尺寸 
     * @support  int $editLineHeight 编辑线高度 
     * @support  string $editAlign 编辑行 
     * @support  int $editToLeft 编辑到左 
     * @support  int $bigScreen 大屏 
     * @support  int $imgToLeft 图片到左距离 
     * @support  int $imgRadius 图片半径 
     * @support  string $editColor 颜色 
     * @support  int $imgRotate 图片旋转度 
     * @support  string $maskImg 顶层蒙层图片 
     * @support  int $onlySquare 只允许正方形图片 
     * @support  int $onlyRectangle 只允许长方形图片 
     * @support  int $editRow 文案编辑行数 
     * @support  int $imgBorderLeft 图片左边框宽度 
     * @support  int $imgBorderRight 图片右边框宽度 
     * @support  int $imgBorderTop 图片上边框宽度 
     * @support  int $imgBorderBottom 图片下边框宽度 
     * @support  string $imgBorderColor 图片边框颜色 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 查询
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (array $product_ids) {
        return self::getClass()->search([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 模本内容存储
     *
     * @support  string $product_name 产品名 [ require true ]
     * @support  int $uid 用户id [ require true ]
     * @support  string $content 模板文字内容 [ require true ]
     * @support  string $store_name 门店名 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function contentCreate () {
        return self::getClass()->contentCreate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'ProductTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'ProductTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}