<?php
namespace Mainto\Bridge\Invokes\DataCenterV2;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method getByParams(array $params)
 * @method getMetaFieldByParams(array $params)
 * @method getMetaIndexByParams(array $params)
 * @method hasByParams(array $params)
 * @method renameByParams(array $params)
 * @method deleteByParams(array $params)
 * @method countByParams(array $params)
 */
class Meta {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $field 配置 [ require true ]
     * @param  array $index index [ require true ]
     * @param  array $dateTimes 时间组【目前支持created_at，updated_at】 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (string $name, array $field = [], array $index = [], array $dateTimes = []) {
        return self::getClass()->create([
            "name" => $name,
            "field" => $field,
            "index" => $index,
            "dateTimes" => $dateTimes,
        ]);
    }

    /**
     * 修改
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $field 配置 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function edit (string $name, array $field = []) {
        return self::getClass()->edit([
            "name" => $name,
            "field" => $field,
        ]);
    }

    /**
     * 获取配置
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function get (string $name) {
        return self::getClass()->get([
            "name" => $name,
        ]);
    }

    /**
     * 获取配置 Field
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMetaField (string $name) {
        return self::getClass()->getMetaField([
            "name" => $name,
        ]);
    }

    /**
     * 获取配置index
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMetaIndex (string $name) {
        return self::getClass()->getMetaIndex([
            "name" => $name,
        ]);
    }

    /**
     * 检查meta是否存在
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function has (string $name) {
        return self::getClass()->has([
            "name" => $name,
        ]);
    }

    /**
     * 更名
     *
     * @param  string $oldName 更改前名称 [ require true ]
     * @param  string $newName 更改后名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function rename (string $oldName, string $newName) {
        return self::getClass()->rename([
            "oldName" => $oldName,
            "newName" => $newName,
        ]);
    }

    /**
     * 删除meta+集合
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (string $name) {
        return self::getClass()->delete([
            "name" => $name,
        ]);
    }

    /**
     * 计算meta个数
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function count (string $name) {
        return self::getClass()->count([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenterV2', 'Meta');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenterV2', 'Meta');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}