<?php
namespace Mainto\Bridge\Invokes\DataCenterV2;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method batchByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateByCondByParams(array $params)
 * @method mergeByParams(array $params)
 * @method findByCondByParams(array $params)
 * @method findByObjectIdByParams(array $params)
 * @method deleteByObjectIdByParams(array $params)
 * @method deleteManyByObjectIdsByParams(array $params)
 * @method deleteByCondByParams(array $params)
 * @method clearByParams(array $params)
 * @method searchByParams(array $params)
 * @method aggregateByParams(array $params)
 */
class Collection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 插入一条
     *
     * @param  string $name 要插入到的名称 [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function add (string $name, array $item) {
        return self::getClass()->add([
            "name" => $name,
            "item" => $item,
        ]);
    }

    /**
     * 插入多条
     *
     * @param  string $name 要插入到的名称 [ require true ]
     * @param  array $items 项目信息s [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batch (string $name, array $items) {
        return self::getClass()->batch([
            "name" => $name,
            "items" => $items,
        ]);
    }

    /**
     * 更新信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $objectId objectId [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (string $name, string $objectId, array $item) {
        return self::getClass()->update([
            "name" => $name,
            "objectId" => $objectId,
            "item" => $item,
        ]);
    }

    /**
     * 更新信息 by cond
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $cond 搜索条件 [ require true ]
     * @param  array $item 更新项 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateByCond (string $name, array $cond, array $item) {
        return self::getClass()->updateByCond([
            "name" => $name,
            "cond" => $cond,
            "item" => $item,
        ]);
    }

    /**
     * 合并信息
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $objectId objectId [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function merge (string $name, string $objectId, array $item) {
        return self::getClass()->merge([
            "name" => $name,
            "objectId" => $objectId,
            "item" => $item,
        ]);
    }

    /**
     * find by cond
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $cond cond [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function findByCond (string $name, array $cond) {
        return self::getClass()->findByCond([
            "name" => $name,
            "cond" => $cond,
        ]);
    }

    /**
     * 读取信息 by id
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $objectId objectId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function findByObjectId (string $name, string $objectId) {
        return self::getClass()->findByObjectId([
            "name" => $name,
            "objectId" => $objectId,
        ]);
    }

    /**
     * 移除 by ObjectId
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $objectId object id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteByObjectId (string $name, string $objectId) {
        return self::getClass()->deleteByObjectId([
            "name" => $name,
            "objectId" => $objectId,
        ]);
    }

    /**
     * 批量移除 by ObjectIds
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $objectIds object ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteManyByObjectIds (string $name, array $objectIds) {
        return self::getClass()->deleteManyByObjectIds([
            "name" => $name,
            "objectIds" => $objectIds,
        ]);
    }

    /**
     * 移除 by Cond
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $cond cond [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteByCond (string $name, array $cond) {
        return self::getClass()->deleteByCond([
            "name" => $name,
            "cond" => $cond,
        ]);
    }

    /**
     * 清空集合
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clear (string $name) {
        return self::getClass()->clear([
            "name" => $name,
        ]);
    }

    /**
     * 搜索
     *
     * @param  string $name 池名称 [ require true ]
     * @param  array $cond 查询条件 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (string $name, array $cond = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->search([
            "name" => $name,
            "cond" => $cond,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 聚合
     *
     * @param  string $name 池名称 [ require true ]
     * @param  array $cond 查询条件 [ require true ]
     * @param  array $aggregateRule 聚合规则 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function aggregate (string $name, array $cond = [], array $aggregateRule = []) {
        return self::getClass()->aggregate([
            "name" => $name,
            "cond" => $cond,
            "aggregateRule" => $aggregateRule,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenterV2', 'Collection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenterV2', 'Collection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}