<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setV2ByParams(array $params)
 * @method getV2ByParams(array $params)
 * @method setByParams(array $params)
 * @method setAndSerializeByParams(array $params)
 * @method getByParams(array $params)
 * @method getAndUnserializeByParams(array $params)
 * @method hasByParams(array $params)
 * @method deleteByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 存
     *
     * @param  string $key 要设置的key [ require true ]
     * @param  string $value 要设置的value [ require true ]
     * @param  int $expireTime 过期时间（秒） [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setV2 (string $key, string $value, int $expireTime = -1) {
        return self::getClass()->setV2([
            "key" => $key,
            "value" => $value,
            "expireTime" => $expireTime,
        ]);
    }

    /**
     * 读
     *
     * @param  string $key 要读取的key [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getV2 (string $key) {
        return self::getClass()->getV2([
            "key" => $key,
        ]);
    }

    /**
     * 存
     *
     * @param  string $key 要设置的key [ require true ]
     * @param  string $value 要设置的value [ require true ]
     * @param  int $expireTime 过期时间（秒） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function set (string $key, string $value, int $expireTime = -1) {
        return self::getClass()->set([
            "key" => $key,
            "value" => $value,
            "expireTime" => $expireTime,
        ]);
    }

    /**
     * 存
     *
     * @param  string $key 要设置的key [ require true ]
     * @param  array $value 要设置的value [ require true ]
     * @param  int $expireTime 过期时间（秒） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAndSerialize (string $key, array $value, int $expireTime = -1) {
        return self::getClass()->setAndSerialize([
            "key" => $key,
            "value" => $value,
            "expireTime" => $expireTime,
        ]);
    }

    /**
     * 读
     *
     * @param  string $key 要读取的key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get (string $key) {
        return self::getClass()->get([
            "key" => $key,
        ]);
    }

    /**
     * 读
     *
     * @param  string $key 要读取的key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAndUnserialize (string $key) {
        return self::getClass()->getAndUnserialize([
            "key" => $key,
        ]);
    }

    /**
     * 查询是否存在
     *
     * @param  string $key 要查询的key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function has (string $key) {
        return self::getClass()->has([
            "key" => $key,
        ]);
    }

    /**
     * 删除
     *
     * @param  string $key 要删除的key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $key) {
        return self::getClass()->delete([
            "key" => $key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}