<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getServerTimeByParams(array|\Mainto\Bridge\Structs\CoreGear\Util\Dto\GetServerTimeDto $params)
 */
class Util {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取服务器时间
     *
     * @var  \Mainto\Bridge\Structs\CoreGear\Util\Dto\GetServerTimeDto $getServerTimeDto
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServerTime (?\Mainto\Bridge\Structs\CoreGear\Util\Dto\GetServerTimeDto $getServerTimeDto = null) {
        return self::getClass()->getServerTime($getServerTimeDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'Util');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'Util');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}