<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUniqueIDByParams(array $params)
 * @method getUniqueIdRangeByParams(array $params)
 * @method setUniqueIDByParams(array $params)
 */
class Unique {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取一个在当前前缀下唯一的ID
     *
     * @param  string $prefix 前缀 [ require true ]
     * @param  string $arrange 预设 [ require true ]
     * @param  int $min_length 值的最小长度，不足将补0 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUniqueID (string $prefix = 'U', string $arrange = '', int $min_length = 0) {
        return self::getClass()->getUniqueID([
            "prefix" => $prefix,
            "arrange" => $arrange,
            "min_length" => $min_length,
        ]);
    }

    /**
     * 获取一个在当前前缀下唯一的ID数组
     * needAll 为 true 时，返回全部 ID 数组
     * needAll 为 false 时，返回如下 map 结构
     * {
     * }
     *
     * @param  string $prefix 前缀 [ require true ]
     * @param  string $arrange 预设 [ require true ]
     * @param  int $min_length 值的最小长度，不足将补0 [ require true ]
     * @param  int $length 要获取的长度 [ require true ]
     * @param  bool $needAll 要获取的长度 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUniqueIdRange (string $prefix = 'U', string $arrange = '', int $min_length = 0, int $length = 1, bool $needAll = false) {
        return self::getClass()->getUniqueIdRange([
            "prefix" => $prefix,
            "arrange" => $arrange,
            "min_length" => $min_length,
            "length" => $length,
            "needAll" => $needAll,
        ]);
    }

    /**
     * 设置当前序列唯一的值
     *
     * @param  string $prefix 前缀 [ require true ]
     * @param  string $arrange 预设 [ require true ]
     * @param  int $value 设置到的值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUniqueID (string $prefix = 'U', string $arrange = '', int $value) {
        return self::getClass()->setUniqueID([
            "prefix" => $prefix,
            "arrange" => $arrange,
            "value" => $value,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'Unique');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'Unique');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}