<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method putSettingByParams(array $params)
 * @method getSettingByParams(array $params)
 * @method deleteSettingByParams(array $params)
 */
class RpcSetting {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 放入设置
     *
     * @param  string $serviceName 服务名称 [ require true ]
     * @param  string $settingName 设置名称 [ require true ]
     * @param  string $configJson 配置Json [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function putSetting (string $serviceName, string $settingName, string $configJson) {
        return self::getClass()->putSetting([
            "serviceName" => $serviceName,
            "settingName" => $settingName,
            "configJson" => $configJson,
        ]);
    }

    /**
     * 获取设置
     *
     * @var  GetSetting\GetSettingDto $getSettingDto $getSettingDto
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSetting (GetSetting\GetSettingDto $getSettingDto) {
        return self::getClass()->getSetting($getSettingDto);
    }

    /**
     * 删除设置
     *
     * @param  string $serviceName 服务名称 [ require true ]
     * @param  string $settingName 设置名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSetting (string $serviceName, string $settingName) {
        return self::getClass()->deleteSetting([
            "serviceName" => $serviceName,
            "settingName" => $settingName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'RpcSetting');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'RpcSetting');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}