<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method newRandomSequenceByLengthByParams(array $params)
 * @method delRandomSequenceByParams(array $params)
 * @method newRandomSequenceByRangeByParams(array $params)
 * @method getRandomSequenceInfoByParams(array $params)
 * @method getNumByParams(array $params)
 * @method get31HexStrByParams(array $params)
 * @method get36HexStrByParams(array $params)
 * @method get52HexStrByParams(array $params)
 * @method get62HexStrByParams(array $params)
 * @method getMD5ByParams(array $params)
 * @method getUUIDByParams(array $params)
 */
class RsaRandom {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据随机长度创建一个序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  uint $length 初始化位数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newRandomSequenceByLength (string $name, int $length) {
        return self::getClass()->newRandomSequenceByLength([
            "name" => $name,
            "length" => $length,
        ]);
    }

    /**
     * 删除指定序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRandomSequence (string $name) {
        return self::getClass()->delRandomSequence([
            "name" => $name,
        ]);
    }

    /**
     * 根据大小范围创建一个序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  uint $min 最小值 [ require true ]
     * @param  uint $max 最大值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newRandomSequenceByRange (string $name, int $min, int $max) {
        return self::getClass()->newRandomSequenceByRange([
            "name" => $name,
            "min" => $min,
            "max" => $max,
        ]);
    }

    /**
     * 获取序列信息
     *
     * @param  string $name 序列名称 [ require true ]
     * @support  uint $min 最小值 require false
     * @support  uint $max 最大值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRandomSequenceInfo (string $name) {
        return self::getClass()->getRandomSequenceInfo([
            "name" => $name,
        ]);
    }

    /**
     * 获取序号
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNum (string $name, int $seq = null) {
        return self::getClass()->getNum([
            "name" => $name,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取31位防误编码 (可能出现的值为 23456789ABCDEFGHJKLMNPQRSTUVWXY)
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  string $length 固定长度,不足前置补Z [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get31HexStr (string $name, string $length = null, int $seq = null) {
        return self::getClass()->get31HexStr([
            "name" => $name,
            "length" => $length,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取36位编码 (可能出现的值为 234567890123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ)
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  string $length 固定长度,不足前置补0 [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get36HexStr (string $name, string $length = null, int $seq = null) {
        return self::getClass()->get36HexStr([
            "name" => $name,
            "length" => $length,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取52位防误编码 (可能出现的值为 2345678ABCDEFGHJKLMNPQRSTUVWXYabcdefhjkmnpqrstuvwxyz)
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  string $length 固定长度,不足前置补Z [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get52HexStr (string $name, string $length = null, int $seq = null) {
        return self::getClass()->get52HexStr([
            "name" => $name,
            "length" => $length,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取62位编码 (可能出现的值为 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz)
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  string $length 固定长度,不足前置补0 [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function get62HexStr (string $name, string $length = null, int $seq = null) {
        return self::getClass()->get62HexStr([
            "name" => $name,
            "length" => $length,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取随机MD5
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMD5 (string $name, int $seq = null) {
        return self::getClass()->getMD5([
            "name" => $name,
            "seq" => $seq,
        ]);
    }

    /**
     * 获取随机UUID
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  uint $seq 不填则自动下一个 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUUID (string $name, int $seq = null) {
        return self::getClass()->getUUID([
            "name" => $name,
            "seq" => $seq,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'RsaRandom');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'RsaRandom');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}