<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLockByParams(array $params)
 * @method unlockByParams(array $params)
 */
class Lock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取一个锁的密码, 失败返回False
     *
     * @param  string $lockName 锁名称 [ require true ]
     * @param  uint $expireTime 过期时间（秒） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLock (string $lockName, int $expireTime = 86400) {
        return self::getClass()->getLock([
            "lockName" => $lockName,
            "expireTime" => $expireTime,
        ]);
    }

    /**
     * 解锁
     *
     * @param  string $lockName 锁名称 [ require true ]
     * @param  string $password 锁密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unlock (string $lockName, string $password) {
        return self::getClass()->unlock([
            "lockName" => $lockName,
            "password" => $password,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'Lock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CoreGear', 'Lock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}