<?php
namespace Mainto\Bridge\Invokes\CoreGear;

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createCountBackwardsSequenceByParams(array $params)
 * @method deleteCountBackwardsSequenceByParams(array $params)
 * @method downByParams(array $params)
 * @method getCurrentByParams(array $params)
 */
class CountBackwards {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个倒数序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  int $start 初始化剩余个数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function createCountBackwardsSequence (string $name, int $start) {
        return self::getClass()->createCountBackwardsSequence([
            "name" => $name,
            "start" => $start,
        ]);
    }

    /**
     * 删除一个倒数序列
     *
     * @param  string $name 序列名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCountBackwardsSequence (string $name) {
        return self::getClass()->deleteCountBackwardsSequence([
            "name" => $name,
        ]);
    }

    /**
     * 进行倒数
     *
     * @param  string $name 序列名称 [ require true ]
     * @param  int $downNum 减掉几个 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function down (string $name, int $downNum = 1) {
        return self::getClass()->down([
            "name" => $name,
            "downNum" => $downNum,
        ]);
    }

    /**
     * 获得当前倒数剩余
     *
     * @param  string $name 序列名称 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getCurrent (string $name) {
        return self::getClass()->getCurrent([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CoreGear', 'CountBackwards');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}