<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-09 12:08:49
 */
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SpotCheckHistory
 */
class SpotCheckHistory {
    private static string $serviceName = "CheckPool";

    private static string $className = "SpotCheckHistory";

    /**
     * 获取抽查结果
     * @return  array
    */
    public static function getSpotCheckResult (string $uuid, array $cond = [], int $skip = 0, int $limit = 1000) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpotCheckResult(["uuid" => $uuid, "cond" => $cond, "skip" => $skip, "limit" => $limit]);
    }
    /**
     * 提交历史信息
     * @return  bool
    */
    public static function commitHistory (string $poolName, string $id, array $commitInfo, string $status = 'commit') {
        return RpcClass::getClass(self::$serviceName, self::$className)->commitHistory(["poolName" => $poolName, "id" => $id, "commitInfo" => $commitInfo, "status" => $status]);
    }
    /**
     * 批量提交
     * @return  array
    */
    public static function batchCommitHistory (string $poolName, array $commitInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCommitHistory(["poolName" => $poolName, "commitInfo" => $commitInfo]);
    }
    /**
     * 搜索历史纪录
     * @return  array
    */
    public static function searchHistory (string $poolName, string $startAt, string $endAt, array $cond = [], int $page = 1, int $pageSize = 10, string $direction = 'asc') {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchHistory(["poolName" => $poolName, "startAt" => $startAt, "endAt" => $endAt, "cond" => $cond, "page" => $page, "pageSize" => $pageSize, "direction" => $direction]);
    }
    /**
     * 搜索历史纪录
     * @return  array
    */
    public static function getHistoryLimit (string $poolName, int $limit, string $startAt, string $endAt, array $cond = [], string $direction = 'asc') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryLimit(["poolName" => $poolName, "limit" => $limit, "startAt" => $startAt, "endAt" => $endAt, "cond" => $cond, "direction" => $direction]);
    }
    /**
     * 根据id获取历史
     * @return  array
    */
    public static function getHistoryById (string $poolName, string $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryById(["poolName" => $poolName, "id" => $id]);
    }
    /**
     * 根据businessId获取历史
     * @return  array
    */
    public static function getHistoryByBusinessId (string $poolName, int $businessId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryByBusinessId(["poolName" => $poolName, "businessId" => $businessId]);
    }
    /**
     * 根据ids查找历史s
     * @return  array
    */
    public static function getHistoryByIds (string $poolName, array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryByIds(["poolName" => $poolName, "ids" => $ids]);
    }
    /**
     * 搜索历史纪录进行批量汇总
     * @return  array
    */
    public static function searchHistoryAggregate (string $poolName, string $startAt, string $endAt, array $cond = [], array $aggregateRule = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchHistoryAggregate(["poolName" => $poolName, "startAt" => $startAt, "endAt" => $endAt, "cond" => $cond, "aggregateRule" => $aggregateRule]);
    }
    /**
     * 批量删除某次抽片记录及详情
     * @return  bool
    */
    public static function batchDeleteHistory (string $uuid, bool $forceDelete = false, bool $cleanRecord = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeleteHistory(["uuid" => $uuid, "forceDelete" => $forceDelete, "cleanRecord" => $cleanRecord]);
    }
    /**
     * 批量删除抽片详情以及回滚
     * @return  bool
    */
    public static function batchDeleteHistoriesAndRollBack (string $poolName, array $uuids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchDeleteHistoriesAndRollBack(["poolName" => $poolName, "uuids" => $uuids]);
    }
    /**
     * 删除单个抽片记录及详情
     * @return  bool
    */
    public static function deleteHistory (string $uuid, string $deleteId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteHistory(["uuid" => $uuid, "deleteId" => $deleteId]);
    }
    /**
     * 修改历史提交信息
     * @return  bool
    */
    public static function editHistoryCommitInfo (string $poolName, string $id, array $commitInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editHistoryCommitInfo(["poolName" => $poolName, "id" => $id, "commitInfo" => $commitInfo]);
    }
    /**
     * 根据businessId修改历史提交信息
     * @return  bool
    */
    public static function editHistoryCommitInfoWithBusinessId (string $poolName, int $businessId, array $commitInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editHistoryCommitInfoWithBusinessId(["poolName" => $poolName, "businessId" => $businessId, "commitInfo" => $commitInfo]);
    }
    /**
     * 根据条件查询记录
     * @return  array
    */
    public static function getHistoryWithCond (string $poolName, array $cond) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryWithCond(["poolName" => $poolName, "cond" => $cond]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}