<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-09 12:08:49
 */
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SpotCheck
 */
class SpotCheck {
    private static string $serviceName = "CheckPool";

    private static string $className = "SpotCheck";

    /**
     * 按条件进行抽查
     * @return  string
    */
    public static function spotCheck (int $operateStaffId, string $poolName, array $where, array $group, int $perNum, bool $remove = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->spotCheck(["operateStaffId" => $operateStaffId, "poolName" => $poolName, "where" => $where, "group" => $group, "perNum" => $perNum, "remove" => $remove]);
    }
    /**
     * 获取抽片最终组合详情
     * @return  mixed
    */
    public static function preSpotCheckInfo (string $poolName, array $where, array $group) {
        return RpcClass::getClass(self::$serviceName, self::$className)->preSpotCheckInfo(["poolName" => $poolName, "where" => $where, "group" => $group]);
    }
    /**
     * 按条件进行抽查(组合版本)
     * @return  string
    */
    public static function multiSpotCheck (int $operateStaffId, string $poolName, array $batchConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->multiSpotCheck(["operateStaffId" => $operateStaffId, "poolName" => $poolName, "batchConfig" => $batchConfig]);
    }
    /**
     * 执行抽查(不需要主动调用)
     * @return  bool
    */
    public static function processSpotCheck (int $operateStaffId, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->processSpotCheck(["operateStaffId" => $operateStaffId, "uuid" => $uuid]);
    }
    /**
     * 更换一个抽查结果
     * @return  array
    */
    public static function changeItem (string $uuid, string $fromId, array $where = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(["uuid" => $uuid, "fromId" => $fromId, "where" => $where]);
    }
    /**
     * 检查是否可更换一个抽查结果
     * @return  bool
    */
    public static function hasChangeItem (string $uuid, string $fromId, array $where = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasChangeItem(["uuid" => $uuid, "fromId" => $fromId, "where" => $where]);
    }
    /**
     * 更换一个抽查结果 - 数据源自定义
     * @return  array
    */
    public static function changeItemByAutomatic (string $uuid, string $fromId, array $item) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItemByAutomatic(["uuid" => $uuid, "fromId" => $fromId, "item" => $item]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}