<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-09 12:08:49
 */
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Pool
 */
class Pool {
    private static string $serviceName = "CheckPool";

    private static string $className = "Pool";

    /**
     * 创建抽查池
     * @return  bool
    */
    public static function createPool (string $poolName, array $config = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPool(["poolName" => $poolName, "config" => $config]);
    }
    /**
     * 修改抽查池
     * @return  bool
    */
    public static function editPool (string $poolName, array $config = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editPool(["poolName" => $poolName, "config" => $config]);
    }
    /**
     * 获取配置
     * @return  mixed
    */
    public static function getPoolConfig (string $poolName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPoolConfig(["poolName" => $poolName]);
    }
    /**
     * 检查抽查池是否存在
     * @return  mixed
    */
    public static function hasPool (string $poolName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasPool(["poolName" => $poolName]);
    }
    /**
     * 更名抽查池
     * @return  bool
    */
    public static function renamePool (string $oldName, string $newName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->renamePool(["oldName" => $oldName, "newName" => $newName]);
    }
    /**
     * 删除抽查池
     * @return  bool
    */
    public static function deletePool (string $poolName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePool(["poolName" => $poolName]);
    }
    /**
     * 计算抽查池个数
     * @return  int
    */
    public static function countPool (string $poolName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->countPool(["poolName" => $poolName]);
    }
    /**
     * addIndex
     * @return  bool
    */
    public static function addIndex (string $poolName, array $config) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addIndex(["poolName" => $poolName, "config" => $config]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}