<?php
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addItemByParams(array $params)
 * @method addItemsByParams(array $params)
 * @method updateItemByParams(array $params)
 * @method mergeItemByParams(array $params)
 * @method findItemByParams(array $params)
 * @method deleteItemByParams(array $params)
 */
class PoolItem {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 插入一条
     *
     * @param  string $poolName 要插入到的池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addItem (string $poolName, int $id, array $item) {
        return self::getClass()->addItem([
            "poolName" => $poolName,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 批量插入
     *
     * @param  string $poolName 要插入到的池名称 [ require true ]
     * @param  array $items 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addItems (string $poolName, array $items) {
        return self::getClass()->addItems([
            "poolName" => $poolName,
            "items" => $items,
        ]);
    }

    /**
     * 更新信息
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateItem (string $poolName, int $id, array $item) {
        return self::getClass()->updateItem([
            "poolName" => $poolName,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 合并信息
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mergeItem (string $poolName, int $id, array $item) {
        return self::getClass()->mergeItem([
            "poolName" => $poolName,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 读取信息
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function findItem (string $poolName, int $id) {
        return self::getClass()->findItem([
            "poolName" => $poolName,
            "id" => $id,
        ]);
    }

    /**
     * 移除信息
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteItem (string $poolName, int $id) {
        return self::getClass()->deleteItem([
            "poolName" => $poolName,
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckPool', 'PoolItem');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckPool', 'PoolItem');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}