<?php
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSpotCheckResultByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method batchCommitHistoryByParams(array $params)
 * @method searchHistoryByParams(array $params)
 * @method searchHistoryAggregateByParams(array $params)
 * @method batchDeleteHistoryByParams(array $params)
 */
class SpotCheckHistory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 当 skip 为 0 时会返回总数量
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  array $cond 查询条件 [ require true ]
     * @param  int $skip 跳过数量 [Original type uint] [ require true ]
     * @param  int $limit 获取数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResult (string $uuid, array $cond = [], int $skip = 0, int $limit = 1000) {
        return self::getClass()->getSpotCheckResult([
            "uuid" => $uuid,
            "cond" => $cond,
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * 提交历史信息
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  string $id 提交ID [ require true ]
     * @param  array $commitInfo 提交信息 [ require true ]
     * @param  string $status 提交状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function commitHistory (string $poolName, string $id, array $commitInfo, string $status = 'commit') {
        return self::getClass()->commitHistory([
            "poolName" => $poolName,
            "id" => $id,
            "commitInfo" => $commitInfo,
            "status" => $status,
        ]);
    }

    /**
     * 批量提交
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  array $commitInfo 提交信息 {$id =&gt; $info} [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCommitHistory (string $poolName, array $commitInfo) {
        return self::getClass()->batchCommitHistory([
            "poolName" => $poolName,
            "commitInfo" => $commitInfo,
        ]);
    }

    /**
     * 搜索历史纪录
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $cond 查询条件 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchHistory (string $poolName, string $startAt, string $endAt, array $cond = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->searchHistory([
            "poolName" => $poolName,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "cond" => $cond,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 搜索历史纪录进行批量汇总
     *
     * @param  string $poolName 池名称 [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  array $cond 查询条件 [ require true ]
     * @param  array $aggregateRule 汇总条件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchHistoryAggregate (string $poolName, string $startAt, string $endAt, array $cond = [], array $aggregateRule = []) {
        return self::getClass()->searchHistoryAggregate([
            "poolName" => $poolName,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "cond" => $cond,
            "aggregateRule" => $aggregateRule,
        ]);
    }

    /**
     * 批量删除某次抽片记录及详情
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  bool $forceDelete 忽略状态检查（可能引起不明bug） [ require true ]
     * @param  bool $cleanRecord 清除抽查记录（通常用不到） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDeleteHistory (string $uuid, bool $forceDelete = false, bool $cleanRecord = false) {
        return self::getClass()->batchDeleteHistory([
            "uuid" => $uuid,
            "forceDelete" => $forceDelete,
            "cleanRecord" => $cleanRecord,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckPool', 'SpotCheckHistory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckPool', 'SpotCheckHistory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}