<?php
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method spotCheckByParams(array $params)
 * @method processSpotCheckByParams(array $params)
 * @method changeItemByParams(array $params)
 */
class SpotCheck {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 推荐 索引 = merge($where + $group)
     *
     * @param  int $operateStaffId 操作人工号 [Original type uint] [ require true ]
     * @param  string $poolName 池名称 [ require true ]
     * @param  array $where 抽查条件 [ require true ]
     * @param  array $group 抽查分组（一维简单数组） [ require true ]
     * @param  int $perNum 每个组抽要到的数目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function spotCheck (int $operateStaffId, string $poolName, array $where, array $group, int $perNum) {
        return self::getClass()->spotCheck([
            "operateStaffId" => $operateStaffId,
            "poolName" => $poolName,
            "where" => $where,
            "group" => $group,
            "perNum" => $perNum,
        ]);
    }

    /**
     * 执行抽查
     *
     * @param  int $operateStaffId 操作人工号 [Original type uint] [ require true ]
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function processSpotCheck (int $operateStaffId, string $uuid) {
        return self::getClass()->processSpotCheck([
            "operateStaffId" => $operateStaffId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 更换一个抽查结果
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  string $fromId 更换来源ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeItem (string $uuid, string $fromId) {
        return self::getClass()->changeItem([
            "uuid" => $uuid,
            "fromId" => $fromId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckPool', 'SpotCheck');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckPool', 'SpotCheck');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}