<?php
namespace Mainto\Bridge\Invokes\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPoolByParams(array $params)
 * @method getPoolConfigByParams(array $params)
 * @method hasPoolByParams(array $params)
 * @method renamePoolByParams(array $params)
 * @method deletePoolByParams(array $params)
 * @method countPoolByParams(array $params)
 */
class Pool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建抽查池
     *
     * @param  string $poolName 名称 [ require true ]
     * @param  array $config 配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPool (string $poolName, array $config = []) {
        return self::getClass()->createPool([
            "poolName" => $poolName,
            "config" => $config,
        ]);
    }

    /**
     * 获取配置
     *
     * @param  string $poolName 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPoolConfig (string $poolName) {
        return self::getClass()->getPoolConfig([
            "poolName" => $poolName,
        ]);
    }

    /**
     * 检查抽查池是否存在
     *
     * @param  string $poolName 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hasPool (string $poolName) {
        return self::getClass()->hasPool([
            "poolName" => $poolName,
        ]);
    }

    /**
     * 更名抽查池
     *
     * @param  string $oldName 更改前名称 [ require true ]
     * @param  string $newName 更改后名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function renamePool (string $oldName, string $newName) {
        return self::getClass()->renamePool([
            "oldName" => $oldName,
            "newName" => $newName,
        ]);
    }

    /**
     * 删除抽查池
     *
     * @param  string $poolName 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deletePool (string $poolName) {
        return self::getClass()->deletePool([
            "poolName" => $poolName,
        ]);
    }

    /**
     * 计算抽查池个数
     *
     * @param  string $poolName 名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function countPool (string $poolName) {
        return self::getClass()->countPool([
            "poolName" => $poolName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckPool', 'Pool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckPool', 'Pool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}