<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBillCheckoutRecordsByParams(array $params)
 * @method getBillDisagreeRecordsByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method billListByParams(array $params)
 * @method getBillsByCondByParams(array $params)
 * @method checkThirdBillByParams(array $params)
 * @method checkBillsWithoutOrderForZhaoShangByParams(array $params)
 * @method getZhaoShangEleReceiptsByFluentNumsByParams(array $params)
 */
class Bill {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取对账列表-分页
     *
     * @support  string $orderNo 订单号 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $result 对账结果 [ require false ]
     * @support  string $source 订单来源 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require false ]
     * @support  string $tradeAtEnd 交易时间末 [ require false ]
     * @support  array $sortScope 排序作用域 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillCheckoutRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getBillCheckoutRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取账单异常列表-分页
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $source 订单来源 [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $tradeAtStart 交易日期始 [ require false ]
     * @support  string $tradeAtEnd 交易时间末 [ require false ]
     * @support  array $sortScope 排序作用域 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillDisagreeRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getBillDisagreeRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  int $recordId 记录ID [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $source 订单来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $recordId, string $orderNo, string $source) {
        return self::getClass()->bindOrder([
            "recordId" => $recordId,
            "orderNo" => $orderNo,
            "source" => $source,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $recordId 记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (int $recordId) {
        return self::getClass()->closeOrder([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 退款操作
     *
     * @param  int $recordId 记录ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundOrder (int $recordId) {
        return self::getClass()->refundOrder([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 根据条件查询账单
     *
     * @support  string $systemReferenceNo 流水的系统参考号 [ require false ]
     * @support  int $status 状态 [ require false ]
     * @support  array $multiStatus 多状态 [ require false ]
     * @support  int $notEqualStatus 不等状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function billList () {
        return self::getClass()->billList([
        ]);
    }

    /**
     * 根据条件查询账单-作废
     * @deprecated
     *
     * @support  string $system_reference_no 流水的系统参考号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillsByCond () {
        return self::getClass()->getBillsByCond([
        ]);
    }

    /**
     * 核对部分没有订单的收入(仅用于工商银行流水)
     *
     * @param  int $id 未对平账单ID [ require true ]
     * @param  string $source 来源 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkThirdBill (int $id, string $source, string $note) {
        return self::getClass()->checkThirdBill([
            "id" => $id,
            "source" => $source,
            "note" => $note,
        ]);
    }

    /**
     * 核对部分没有订单的收入(仅用于招商银行流水)
     *
     * @param  array $bankAccountFluentNums 唯一编号列表 [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @param  string $status 标记为的状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkBillsWithoutOrderForZhaoShang (array $bankAccountFluentNums, string $module, string $note, string $status = 'used') {
        return self::getClass()->checkBillsWithoutOrderForZhaoShang([
            "bankAccountFluentNums" => $bankAccountFluentNums,
            "module" => $module,
            "note" => $note,
            "status" => $status,
        ]);
    }

    /**
     * 补全招行打款回单记录,仅供business调用
     *
     * @param  array $fluentNums 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getZhaoShangEleReceiptsByFluentNums (array $fluentNums = []) {
        return self::getClass()->getZhaoShangEleReceiptsByFluentNums([
            "fluentNums" => $fluentNums,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Bill');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Bill');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}