<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryReportsByParams(array $params)
 * @method aggregateReportsByParams(array $params)
 * @method resetReportsByParams(array $params)
 */
class BillReport {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成财务报表
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $tradeAtStart 开始日期 [ require false ]
     * @support  string $tradeAtEnd 截止日期 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryReports () {
        return self::getClass()->queryReports([
        ]);
    }

    /**
     * 聚合报表查询
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $tradeAtStart 开始日期 [ require false ]
     * @support  string $tradeAtEnd 截止日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function aggregateReports () {
        return self::getClass()->aggregateReports([
        ]);
    }

    /**
     * 报表重置
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetReports (string $date) {
        return self::getClass()->resetReports([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'BillReport');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'BillReport');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}