<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryAlipayBillsByParams(array $params)
 * @method queryWechatBillsByParams(array $params)
 * @method queryPayMaxBillsByParams(array $params)
 * @method queryEnterpriseBillsByParams(array $params)
 * @method queryElectronicReceiptByParams(array $params)
 * @method queryOrdersByParams(array $params)
 * @method billCheckByParams(array $params)
 * @method batchReloadDeferOrdersByParams(array $params)
 * @method receiveEnterpriseBillsByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付宝账单拉取
     *
     * @support  string $date 拉取日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryAlipayBills ($context) {
        return self::getClass()->queryAlipayBills([
            "context" => $context,
        ]);
    }

    /**
     * 微信账单拉取
     *
     * @support  string $date 拉取日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryWechatBills ($context) {
        return self::getClass()->queryWechatBills([
            "context" => $context,
        ]);
    }

    /**
     * 拉卡拉账单拉取
     *
     * @support  string $date 拉取日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryPayMaxBills ($context) {
        return self::getClass()->queryPayMaxBills([
            "context" => $context,
        ]);
    }

    /**
     * 招行对公打款账单拉取
     *
     * @support  string $date 拉取日期 [ require false ]
     * @support  array $body body数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryEnterpriseBills ($context) {
        return self::getClass()->queryEnterpriseBills([
            "context" => $context,
        ]);
    }

    /**
     * 招行回单拉取
     *
     * @support  string $date 拉取日期 [ require false ]
     * @support  array $body body数据 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryElectronicReceipt ($context) {
        return self::getClass()->queryElectronicReceipt([
            "context" => $context,
        ]);
    }

    /**
     * 订单拉取
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrders () {
        return self::getClass()->queryOrders();
    }

    /**
     * 账单校对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function billCheck () {
        return self::getClass()->billCheck();
    }

    /**
     * 更新延迟处理订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchReloadDeferOrders () {
        return self::getClass()->batchReloadDeferOrders();
    }

    /**
     * 对公打款账单拉取,仅供第三方企业保融调用
     *
     * @param  array $req 数据包 [ require true ]
     * @param  string $sign 签名摘要 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveEnterpriseBills (array $req, string $sign) {
        return self::getClass()->receiveEnterpriseBills([
            "req" => $req,
            "sign" => $sign,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}