<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBillCheckoutListByParams(array $params)
 * @method getBillDisagreeListByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method getBillsByCondByParams(array $params)
 * @method checkBillWithoutOrderByParams(array $params)
 * @method checkBillWithoutOrderForZhaoShangByParams(array $params)
 */
class Bill {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取对平账单列表
     *
     * @support  int $storeId 门店ID [ require false ]
     * @support  string $payType 支付方式 [ require false ]
     * @support  string $date 日期 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillCheckoutList ($context, int $page = 1, int $pageSize = 20) {
        return self::getClass()->getBillCheckoutList([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取账单异常列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillDisagreeList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getBillDisagreeList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  int $id 未对平账单ID [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $orderType 订单类型 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $id, string $orderNo, string $orderType, string $note) {
        return self::getClass()->bindOrder([
            "id" => $id,
            "orderNo" => $orderNo,
            "orderType" => $orderType,
            "note" => $note,
        ]);
    }

    /**
     * 根据条件查询账单
     *
     * @support  string $system_reference_no 流水的系统参考号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBillsByCond ($context) {
        return self::getClass()->getBillsByCond([
            "context" => $context,
        ]);
    }

    /**
     * 核对部分没有订单的收入(仅用于工商银行流水)
     *
     * @param  int $id 未对平账单ID [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkBillWithoutOrder (int $id, string $module, string $note) {
        return self::getClass()->checkBillWithoutOrder([
            "id" => $id,
            "module" => $module,
            "note" => $note,
        ]);
    }

    /**
     * 核对部分没有订单的收入(仅用于招商银行流水)
     *
     * @param  string $bankAccountFluentNum 唯一编号 [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @param  string $status 标记为的状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkBillWithoutOrderForZhaoShang (string $bankAccountFluentNum, string $module, string $note, string $status = 'used') {
        return self::getClass()->checkBillWithoutOrderForZhaoShang([
            "bankAccountFluentNum" => $bankAccountFluentNum,
            "module" => $module,
            "note" => $note,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Bill');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Bill');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}