<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryAlipayBillsByParams(array $params)
 * @method queryWechatBillsByParams(array $params)
 * @method queryPayMaxBillsByParams(array $params)
 * @method queryOrdersByParams(array $params)
 * @method billCheckByParams(array $params)
 * @method queryEnterpriseBillsByParams(array $params)
 * @method releaseBillLockByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付宝账单拉取
     *
     * @support  string $date 拉取日期 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryAlipayBills () {
        return self::getClass()->queryAlipayBills();
    }

    /**
     * 微信账单拉取
     *
     * @support  string $date 拉取日期 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryWechatBills () {
        return self::getClass()->queryWechatBills();
    }

    /**
     * 拉卡拉账单拉取
     *
     * @support  string $date 拉取日期 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryPayMaxBills () {
        return self::getClass()->queryPayMaxBills();
    }

    /**
     * 订单拉取
     *
     * @support  string $date 日期 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrders () {
        return self::getClass()->queryOrders();
    }

    /**
     * 账单校对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function billCheck () {
        return self::getClass()->billCheck();
    }

    /**
     * 对公打款账单拉取,仅供第三方企业保融调用
     *
     * @param  array $req 数据包 [ require true ]
     * @param  string $sign 签名摘要 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryEnterpriseBills (array $req, string $sign) {
        return self::getClass()->queryEnterpriseBills([
            "req" => $req,
            "sign" => $sign,
        ]);
    }

    /**
     * 释放锁的账单-每天凌晨释放锁住前一天锁住的账单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function releaseBillLock () {
        return self::getClass()->releaseBillLock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}