<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderDisagreeRecordsByParams(array $params)
 * @method deleteDisagreeOrderByParams(array $params)
 * @method attachTurnoverByParams(array $params)
 * @method deferLoadOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单核对异常列表
     *
     * @support  int $storeId 门店ID require false
     * @support  string $source 订单来源 require false
     * @support  string $payType 支付方式 require false
     * @support  string $tradeAtStart 交易日期始 require false
     * @support  string $tradeAtEnd 交易时间末 require false
     * @support  array $sortScope 排序作用域 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDisagreeRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOrderDisagreeRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $reason 原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDisagreeOrder (string $orderNo, string $reason) {
        return self::getClass()->deleteDisagreeOrder([
            "orderNo" => $orderNo,
            "reason" => $reason,
        ]);
    }

    /**
     * 补充流水
     *
     * @param  int $id 记录ID [ require true ]
     * @support  string $paymentNo 流水号 [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $payAt 支付时间 require false
     * @support  string $note 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function attachTurnover (int $id) {
        return self::getClass()->attachTurnover([
            "id" => $id,
        ]);
    }

    /**
     * 延期处理
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $date 订单号 [ require true ]
     * @param  string $reason 原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deferLoadOrder (string $orderNo, string $date, string $reason) {
        return self::getClass()->deferLoadOrder([
            "orderNo" => $orderNo,
            "date" => $date,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}