<?php
namespace Mainto\Bridge\Enums\CheckBill;

class BillSupportPayTypeEnum {
    /**
     * 支持所有类型
     */
    const ALL_SUPPORT_TYPES = [0 => 'paymax_wx_app',1 => 'paymax_alipay_mini_app',2 => 'offline_paymax_bankcard',3 => 'offline_paymax_wechat',4 => 'offline_paymax_alipay',5 => 'paymax_wechat',6 => 'paymax_alipay'];
    /**
     * 线上订单支持的支付类型
     */
    const ONLINE_ORDER_SUPPORT_PAY_TYPES = [0 => 'alipay',1 => 'wechat',2 => 'icbc_wechat',3 => 'paymax_wechat',4 => 'paymax_alipay',5 => 'offline_paymax_alipay',6 => 'offline_paymax_wechat',7 => 'offline_paymax_bankcard',8 => 'paymax_wx_app'];
    /**
     * 支付枚举映射
     */
    const ALL_PAY_TYPE_MAP = ['Alipay' => 'alipay','Wechat' => 'wechat','ICBCWechat' => 'icbc_wechat','PaymaxWechat' => 'paymax_wechat','PaymaxAlipay' => 'paymax_alipay','PaymaxWXApp' => 'paymax_wx_app','OffPaymaxAlipay' => 'offline_paymax_alipay','OffPaymaxWechat' => 'offline_paymax_wechat','OffPaymaxCard' => 'offline_paymax_bankcard'];
    /**
     * 拉卡拉支付枚举映射
     */
    const ALL_PAY_MAX_MAP = ['wechat' => 'wechat','alipay' => 'alipay','paymax_wechat' => 'paymax_wechat','paymax_alipay' => 'paymax_alipay','paymax_wx_app' => 'paymax_wechat','offline_paymax_alipay' => 'paymax_alipay','offline_paymax_wechat' => 'paymax_wechat','offline_paymax_bankcard' => 'offline_paymax_bankcard'];
    /**
     * 拉卡拉支付类型
     */
    const ALL_PAX_MAX_PAY_TYPES = [0 => 'PaymaxAlipay',1 => 'PaymaxWechat',2 => 'OffPaymaxWechat',3 => 'OffPaymaxAlipay',4 => 'OffPaymaxCard',5 => 'PaymaxWXApp'];
    /**
     * 支持的报表类型
     */
    const SUPPORT_REPORT_PAY_TYPES = [0 => 'wechat',1 => 'alipay',2 => 'paymax_wechat',3 => 'paymax_wx_app',4 => 'paymax_alipay',5 => 'offline_paymax_bankcard',6 => 'offline_paymax_wechat',7 => 'offline_paymax_alipay'];
    /**
     * 拉卡拉支持两种类型
     */
    const SUPPORT_PAX_MAX_PAY_TYPES = [0 => 'paymax_wechat',1 => 'paymax_alipay'];
}