<?php
namespace Mainto\Bridge\Enums\CheckBill;

class ErrorEventEnum {
    /**
     * 账单丢失
     */
    const BILL_LOST = 'bill_lost';
    /**
     * 订单丢失
     */
    const ORDER_LOST = 'order_lost';
    /**
     * 支付账单丢失
     */
    const PAYMENT_BILL_LOST = 'payment_bill_lost';
    /**
     * 支付类型不一致
     */
    const PAYMENT_TYPE_NOT_INCONSISTENT = 'payment_type_not_inconsistent';
    /**
     * 支付金额不一致
     */
    const PAYMENT_MONEY_NOT_INCONSISTENT = 'payment_money_not_inconsistent';
    /**
     * 读取excel文件错误
     */
    const READ_EXCEL_FILE_ERROR = 'error_reading_excel_file';
    /**
     * 加载excel文件错误
     */
    const LOAD_EXCEL_FILE_ERROR = 'error_loading_excel_file';
    /**
     * 微信账单查询失败
     */
    const WECHAT_BILL_QUERY_FAIL = 'wechat_bill_query_failed';
    /**
     * 支付宝账单查询失败
     */
    const ALIPAY_BILL_QUERY_FAIL = 'alipay_bill_query_failed';
}