<?php
namespace Mainto\Bridge\Invokes\CheckBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBillCheckoutListByParams(array $params)
 * @method getBillDisagreeListByParams(array $params)
 * @method bindOrderByParams(array $params)
 */
class Bill {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取对平账单列表
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  string $payType 支付方式 
     * @support  string $date 日期 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBillCheckoutList (int $page, int $pageSize) {
        return self::getClass()->getBillCheckoutList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取账单异常列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBillDisagreeList (int $page, int $pageSize) {
        return self::getClass()->getBillDisagreeList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  int $id 未对平账单ID [Original type uint] [ require true ]
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $orderType 订单类型 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $id, string $orderNo, string $orderType, string $note) {
        return self::getClass()->bindOrder([
            "id" => $id,
            "orderNo" => $orderNo,
            "orderType" => $orderType,
            "note" => $note,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('CheckBill', 'Bill');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('CheckBill', 'Bill');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}