<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-21 14:56:27
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PaymentRecord
 * @method addAppendPaymentByParams(array $params) 录入追加付款/version3.0.0起不再支持追加付款
 * @method editAppendPaymentByParams(array $params) 编辑追加付款/version3.0.0起不再支持追加付款
 * @method deleteAppendPaymentRecordByParams(array $params) 删除追加付款/version3.0.0起不再支持追加付款
 * @method appendPaymentRecordListByParams(array $params) 获取追加付款记录列表(仅限于单订单合同)
 * @method createPaymentRecordByParams(array $params) 新增付款
 * @method autoCreatePaymentRecordByParams(array $params) 通过bill服务的消息自动创建支付记录
 * @method autoAddPaymentEvidenceByParams(array $params) 通过bill服务的消息自动添加支付凭证
 * @method createPaymentUrlByParams(array $params) 新增远程收款
 * @method deletePaymentRecordByParams(array $params) 删除付款记录
 * @method paymentRecordListByParams(array $params) 获取付款记录列表
 * @method getBillInfoByFluentNumByParams(array $params) 查询付款信息
 * @method payCallbackByParams(array $params) 远程支付回调
 * @method findPaymentRecordByParams(array $params) 搜索收款记录
 * @method transferFundAccountByParams(array $params) 工具台：收款转移资金账户
 */
class PaymentRecord {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\PaymentRecord";

    /**
     * 录入追加付款/version3.0.0起不再支持追加付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addAppendPayment (int $id, float $pay_money, string $pay_type, array $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addAppendPayment(["id" => $id, "pay_money" => $pay_money, "pay_type" => $pay_type, "evidence" => $evidence]);
    }

    /**
     * 编辑追加付款/version3.0.0起不再支持追加付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editAppendPayment (int $id, float $pay_money, string $pay_type, array $evidence) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAppendPayment(["id" => $id, "pay_money" => $pay_money, "pay_type" => $pay_type, "evidence" => $evidence]);
    }

    /**
     * 删除追加付款/version3.0.0起不再支持追加付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteAppendPaymentRecord (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteAppendPaymentRecord(["id" => $id]);
    }

    /**
     * 获取追加付款记录列表(仅限于单订单合同)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function appendPaymentRecordList (int $id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->appendPaymentRecordList(["id" => $id, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 新增付款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createPaymentRecord (array $evidence, string $pay_type, string $fluent_num, int $account_id, float $pay_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentRecord(["evidence" => $evidence, "pay_type" => $pay_type, "fluent_num" => $fluent_num, "account_id" => $account_id, "pay_money" => $pay_money]);
    }

    /**
     * 通过bill服务的消息自动创建支付记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function autoCreatePaymentRecord (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCreatePaymentRecord(["data" => $data]);
    }

    /**
     * 通过bill服务的消息自动添加支付凭证
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function autoAddPaymentEvidence (array $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoAddPaymentEvidence(["data" => $data]);
    }

    /**
     * 新增远程收款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createPaymentUrl (int $account_id, float $pay_money) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPaymentUrl(["account_id" => $account_id, "pay_money" => $pay_money]);
    }

    /**
     * 删除付款记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deletePaymentRecord (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePaymentRecord(["id" => $id]);
    }

    /**
     * 获取付款记录列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function paymentRecordList (int $account_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->paymentRecordList(["account_id" => $account_id, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 查询付款信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getBillInfoByFluentNum (string $fluentNum, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBillInfoByFluentNum(["fluentNum" => $fluentNum, "payType" => $payType]);
    }

    /**
     * 远程支付回调
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function payCallback (string $data) {
        return RpcClass::getClass(self::$serviceName, self::$className)->payCallback(["data" => $data]);
    }

    /**
     * 搜索收款记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function findPaymentRecord () {
        return RpcClass::getClass(self::$serviceName, self::$className)->findPaymentRecord([]);
    }

    /**
     * 工具台：收款转移资金账户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function transferFundAccount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferFundAccount([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}