<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-25 15:02:18
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Contract
 * @method contractListByParams(array $params) 查询业务合同
 * @method yearContractListByParams(array $params) 查询框架合同
 * @method getBindContractListByParams(array $params) 获取可以绑定业务合同
 * @method createContractByParams(array $params) 创建业务合同
 * @method createYearContractByParams(array $params) 创建框架合同
 * @method contractDetailByParams(array $params) 业务合同详情
 * @method yearContractDetailByParams(array $params) 框架合同详情
 * @method editContractByParams(array $params) 修改合同
 * @method deleteContractByParams(array $params) 删除合同
 * @method uploadFinalFileByParams(array $params) 上传盖印合同
 * @method getBindOrdersByParams(array $params) 获取框架合同绑定订单列表
 * @method syncUpdateContractByParams(array $params) 合同变更更新
 * @method syncCreateContractByParams(array $params) 合同新增
 * @method editContractDiscountInfoByParams(array $params) 编辑合同折扣
 * @method editYearContractDiscountInfoByParams(array $params) 编辑合同折扣
 */
class Contract {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Contract";

    /**
     * 查询业务合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\ContractList\ContractListDTO
    */
    public static function contractList (int $creatorId = 0, int $page = 1, int $pageSize = 10, string $descSortColumn = 'created_at', string $contractType = 'normal_contract') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contractList(["creatorId" => $creatorId, "page" => $page, "pageSize" => $pageSize, "descSortColumn" => $descSortColumn, "contractType" => $contractType]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\ContractList\ContractListDTO"
        );
    }

    /**
     * 查询框架合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\YearContractList\YearContractListDTO
    */
    public static function yearContractList (int $creatorId = 0, int $page = 1, int $pageSize = 10, string $descSortColumn = 'created_at') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->yearContractList(["creatorId" => $creatorId, "page" => $page, "pageSize" => $pageSize, "descSortColumn" => $descSortColumn]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\YearContractList\YearContractListDTO"
        );
    }

    /**
     * 获取可以绑定业务合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\BindContractList\BindContractListDTO
    */
    public static function getBindContractList (string $descSortColumn = 'passed_at') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBindContractList(["descSortColumn" => $descSortColumn]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\BindContractList\BindContractListDTO"
        );
    }

    /**
     * 创建业务合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\CreateContract\CreateContractDTO
    */
    public static function createContract (string $customerPhone, string $enterpriseName, string $trade, string $link, int $contractArea, int $enterpriseId, float $contractMoney, string $contractFilePath, string $contractFileName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createContract(["customerPhone" => $customerPhone, "enterpriseName" => $enterpriseName, "trade" => $trade, "link" => $link, "contractArea" => $contractArea, "enterpriseId" => $enterpriseId, "contractMoney" => $contractMoney, "contractFilePath" => $contractFilePath, "contractFileName" => $contractFileName]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\CreateContract\CreateContractDTO"
        );
    }

    /**
     * 创建框架合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\CreateYearContract\CreateYearContractDTO
    */
    public static function createYearContract (string $customerPhone, string $trade, string $link, int $contractArea, int $enterpriseId, string $contractFilePath, string $contractFileName) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createYearContract(["customerPhone" => $customerPhone, "trade" => $trade, "link" => $link, "contractArea" => $contractArea, "enterpriseId" => $enterpriseId, "contractFilePath" => $contractFilePath, "contractFileName" => $contractFileName]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\CreateYearContract\CreateYearContractDTO"
        );
    }

    /**
     * 业务合同详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\ContractDetail\ContractDetailDTO
    */
    public static function contractDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->contractDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\ContractDetail\ContractDetailDTO"
        );
    }

    /**
     * 框架合同详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\YearContractDetail\YearContractDetailDTO
    */
    public static function yearContractDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->yearContractDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\YearContractDetail\YearContractDetailDTO"
        );
    }

    /**
     * 修改合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editContract (int $id, string $contract_type, string $customer_phone, string $trade, string $link, int $contract_area, int $enterprise_id, string $contract_file_path, string $contract_file_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editContract(["id" => $id, "contract_type" => $contract_type, "customer_phone" => $customer_phone, "trade" => $trade, "link" => $link, "contract_area" => $contract_area, "enterprise_id" => $enterprise_id, "contract_file_path" => $contract_file_path, "contract_file_name" => $contract_file_name]);
    }

    /**
     * 删除合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteContract (int $id, string $contract_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteContract(["id" => $id, "contract_type" => $contract_type]);
    }

    /**
     * 上传盖印合同
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function uploadFinalFile (int $contract_id, string $contract_type, string $final_file_path, string $final_file_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadFinalFile(["contract_id" => $contract_id, "contract_type" => $contract_type, "final_file_path" => $final_file_path, "final_file_name" => $final_file_name]);
    }

    /**
     * 获取框架合同绑定订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBindOrders (int $contract_id, int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBindOrders(["contract_id" => $contract_id, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 合同变更更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\SyncUpdateContract\SyncUpdateContractDTO
    */
    public static function syncUpdateContract (string $oppositeContactPhone, string $oppositeContact, string $industryType, int $placingAreaCode, string $contractCode, bool $bothType, string $contractTypeCode, float $signClassDiscount, float $otherProductDiscount, float $giftCardDiscount, float $orderDiscountCodeDiscount, string $token) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->syncUpdateContract(["oppositeContactPhone" => $oppositeContactPhone, "oppositeContact" => $oppositeContact, "industryType" => $industryType, "placingAreaCode" => $placingAreaCode, "contractCode" => $contractCode, "bothType" => $bothType, "contractTypeCode" => $contractTypeCode, "signClassDiscount" => $signClassDiscount, "otherProductDiscount" => $otherProductDiscount, "giftCardDiscount" => $giftCardDiscount, "orderDiscountCodeDiscount" => $orderDiscountCodeDiscount, "token" => $token]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\SyncUpdateContract\SyncUpdateContractDTO"
        );
    }

    /**
     * 合同新增
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Contract\SyncCreateContract\SyncCreateContractDTO
    */
    public static function syncCreateContract (string $token, int $enterpriseId, int $applyLoginName, string $oppositeContactPhone, array $auditorInfo, string $contractEndAuditDate, string $contractCreateDate, string $oppositeContact, string $industryType, int $placingAreaCode, string $contractCode, string $contractTypeCode, bool $bothType, float $otherProductDiscount, float $giftCardDiscount, float $orderDiscountCodeDiscount) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->syncCreateContract(["token" => $token, "enterpriseId" => $enterpriseId, "applyLoginName" => $applyLoginName, "oppositeContactPhone" => $oppositeContactPhone, "auditorInfo" => $auditorInfo, "contractEndAuditDate" => $contractEndAuditDate, "contractCreateDate" => $contractCreateDate, "oppositeContact" => $oppositeContact, "industryType" => $industryType, "placingAreaCode" => $placingAreaCode, "contractCode" => $contractCode, "contractTypeCode" => $contractTypeCode, "bothType" => $bothType, "otherProductDiscount" => $otherProductDiscount, "giftCardDiscount" => $giftCardDiscount, "orderDiscountCodeDiscount" => $orderDiscountCodeDiscount]),
            "\Mainto\Bridge\Structs\Business\DTO\Contract\SyncCreateContract\SyncCreateContractDTO"
        );
    }

    /**
     * 编辑合同折扣
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editContractDiscountInfo (string $contractNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editContractDiscountInfo(["contractNo" => $contractNo]);
    }

    /**
     * 编辑合同折扣
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editYearContractDiscountInfo (string $contractNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editYearContractDiscountInfo(["contractNo" => $contractNo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}