<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-25 15:02:18
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Clue
 * @method addClueByParams(array $params) 创建线索
 * @method addClueforAllCompanyByParams(array $params) 创建线索（钉钉录入）
 * @method createClueByParams(array $params) 创建线索（待删除）
 * @method createStoreByParams(array $params) 创建线索(门店)
 * @method editClueByParams(array $params) 编辑线索
 * @method clueDetailByParams(array $params) 线索详情
 * @method clueListByParams(array $params) 线索列表
 * @method clueSimpleListByParams(array $params) 线索列表（简易）
 * @method clueListByWxByParams(array $params) 门店端线索列表
 * @method clueAllByParams(array $params) 线索列表
 * @method abandonClueByParams(array $params) 放弃线索
 * @method receiveClueByParams(array $params) 领取线索
 * @method transferClueByParams(array $params) 转移线索
 * @method distributionClueByParams(array $params) 分配线索
 * @method checkTransferClueToEnterpriseByParams(array $params) 校验线索转企业
 * @method transferClueToEnterpriseByParams(array $params) 转移线索成企业
 * @method clueRateByParams(array $params) 线索转化率成交率统计
 */
class Clue {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Clue";

    /**
     * 创建线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addClue (string $title, string $contactName, string $contactPhone, int $photographArea, int $belongStaff, string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClue(["title" => $title, "contactName" => $contactName, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "belongStaff" => $belongStaff, "scene" => $scene]);
    }

    /**
     * 创建线索（钉钉录入）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function addClueforAllCompany (string $title, string $contactName, int $contactPhone, int $photographArea, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClueforAllCompany(["title" => $title, "contactName" => $contactName, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "scene" => $scene]);
    }

    /**
     * 创建线索（待删除）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createClue (string $contact_name, string $contact_phone, int $photograph_area, int $belong_staff, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createClue(["contact_name" => $contact_name, "contact_phone" => $contact_phone, "photograph_area" => $photograph_area, "belong_staff" => $belong_staff, "scene" => $scene]);
    }

    /**
     * 创建线索(门店)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createStore (string $title, string $contactName, string $contactPhone, int $photographArea, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStore(["title" => $title, "contactName" => $contactName, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "scene" => $scene]);
    }

    /**
     * 编辑线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editClue (int $clueId, string $contactName, string $contactPhone, int $photographArea, string $scene = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->editClue(["clueId" => $clueId, "contactName" => $contactName, "contactPhone" => $contactPhone, "photographArea" => $photographArea, "scene" => $scene]);
    }

    /**
     * 线索详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueDetail\ClueDetailDTO
    */
    public static function clueDetail (int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueDetail(["clueId" => $clueId]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueDetail\ClueDetailDTO"
        );
    }

    /**
     * 线索列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueList\ClueListDTO
    */
    public static function clueList (int $page = 1, int $pageSize = 10, string $descSortColumn = 'log_at', bool $isInvalid = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueList(["page" => $page, "pageSize" => $pageSize, "descSortColumn" => $descSortColumn, "isInvalid" => $isInvalid]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueList\ClueListDTO"
        );
    }

    /**
     * 线索列表（简易）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueSimpleList\ClueSimpleListDTO
    */
    public static function clueSimpleList (string $from, int $storeId, int $pageSize = 10, int $page = 1) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueSimpleList(["from" => $from, "storeId" => $storeId, "pageSize" => $pageSize, "page" => $page]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueSimpleList\ClueSimpleListDTO"
        );
    }

    /**
     * 门店端线索列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function clueListByWx () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueListByWx([]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueListByWx\ClueListByWxDTO[]"
        );
    }

    /**
     * 线索列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function clueAll (string $descSortColumn = 'log_at', bool $isInvalid = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueAll(["descSortColumn" => $descSortColumn, "isInvalid" => $isInvalid]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueAll\ClueAllDTO[]"
        );
    }

    /**
     * 放弃线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function abandonClue (int $clueId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->abandonClue(["clueId" => $clueId]);
    }

    /**
     * 领取线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function receiveClue (int $clueId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveClue(["clueId" => $clueId]);
    }

    /**
     * 转移线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function transferClue (int $clueId, int $receiveStaff) {
        return RpcClass::getClass(self::$serviceName, self::$className)->transferClue(["clueId" => $clueId, "receiveStaff" => $receiveStaff]);
    }

    /**
     * 分配线索
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function distributionClue (int $clueId, int $receiveStaff) {
        return RpcClass::getClass(self::$serviceName, self::$className)->distributionClue(["clueId" => $clueId, "receiveStaff" => $receiveStaff]);
    }

    /**
     * 校验线索转企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\CheckTransferClueToEnterprise\CheckTransferClueToEnterpriseDTO
    */
    public static function checkTransferClueToEnterprise (int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkTransferClueToEnterprise(["clueId" => $clueId]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\CheckTransferClueToEnterprise\CheckTransferClueToEnterpriseDTO"
        );
    }

    /**
     * 转移线索成企业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\TransferClueToEnterprise\TransferClueToEnterpriseDTO
    */
    public static function transferClueToEnterprise (int $clueId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->transferClueToEnterprise(["clueId" => $clueId]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\TransferClueToEnterprise\TransferClueToEnterpriseDTO"
        );
    }

    /**
     * 线索转化率成交率统计
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\Clue\ClueRate\ClueRateDTO
    */
    public static function clueRate () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueRate([]),
            "\Mainto\Bridge\Structs\Business\DTO\Clue\ClueRate\ClueRateDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}