<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-25 10:44:00
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ClueRule
 * @method addClueRuleByParams(array $params) 创建线索规则
 * @method deleteClueRuleByParams(array $params) 删除线索规则
 * @method editClueRuleByParams(array $params) 修改线索规则
 * @method clueRuleListByParams(array $params) 查询线索规则
 * @method clueRuleDetailByParams(array $params) 线索规则详情
 */
class ClueRule {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\ClueRule";

    /**
     * 创建线索规则
     * @return  bool
    */
    public static function addClueRule (\Mainto\Bridge\Structs\Business\Cmd\ClueRule\CreateClueRuleCmd $createClueRuleCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addClueRule($createClueRuleCmd);
    }

    /**
     * 删除线索规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteClueRule (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteClueRule(["id" => $id]);
    }

    /**
     * 修改线索规则
     * @return  bool
    */
    public static function editClueRule (\Mainto\Bridge\Structs\Business\Cmd\ClueRule\EditClueRuleCmd $editClueRuleCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editClueRule($editClueRuleCmd);
    }

    /**
     * 查询线索规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\ClueRule\ClueRuleListDTO
    */
    public static function clueRuleList (int $pageNo = 1, int $pageSize = 10, string $name = '') {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueRuleList(["pageNo" => $pageNo, "pageSize" => $pageSize, "name" => $name]),
            "\Mainto\Bridge\Structs\Business\DTO\ClueRule\ClueRuleListDTO"
        );
    }

    /**
     * 线索规则详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\Business\DTO\ClueRule\ClueRuleDetailDTO
    */
    public static function clueRuleDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->clueRuleDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\Business\DTO\ClueRule\ClueRuleDetailDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}