<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-05-29 12:16:15
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Preferential
 * @method exportPreferentialListByParams(array $params) 导出券码列表
 * @method getPreferentialUseInfoByParams(array $params) 获取券码使用详情
 * @method exportPreferentialUseInfoPartByParams(array $params) 导出券码使用详情(部分)
 * @method exportPreferentialUseInfoByParams(array $params) 导出券码使用详情(全部)
 * @method allGiftCardCoverByParams(array $params) 获取礼品卡卡面列表(全部)
 * @method batchAbolishByParams(array $params) 批量券码作废
 * @method getGiftCardCoverByStoreIdByParams(array $params) 获取门店1030店铺实体礼品卡面信息
 * @method getProductCardByStoreIdByParams(array $params) 获取门店1030店铺实体产品卡信息
 */
class Preferential {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Preferential";

    /**
     * 导出券码列表
     * @return  mixed
    */
    public static function exportPreferentialList (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialList(["order_id" => $order_id]);
    }
    /**
     * 获取券码使用详情
     * @return  mixed
    */
    public static function getPreferentialUseInfo (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialUseInfo(["order_id" => $order_id]);
    }
    /**
     * 导出券码使用详情(部分)
     * @return  mixed
    */
    public static function exportPreferentialUseInfoPart (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfoPart(["order_id" => $order_id]);
    }
    /**
     * 导出券码使用详情(全部)
     * @return  mixed
    */
    public static function exportPreferentialUseInfo (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportPreferentialUseInfo(["order_id" => $order_id]);
    }
    /**
     * 获取礼品卡卡面列表(全部)
     * @return  mixed
    */
    public static function allGiftCardCover () {
        return RpcClass::getClass(self::$serviceName, self::$className)->allGiftCardCover([]);
    }
    /**
     * 批量券码作废
     * @return  mixed
    */
    public static function batchAbolish (int $order_id, array $codes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAbolish(["order_id" => $order_id, "codes" => $codes]);
    }
    /**
     * 获取门店1030店铺实体礼品卡面信息
     * @return  array
    */
    public static function getGiftCardCoverByStoreId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGiftCardCoverByStoreId([]);
    }
    /**
     * 获取门店1030店铺实体产品卡信息
     * @return  mixed
    */
    public static function getProductCardByStoreId () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardByStoreId([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}