<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-21 15:56:05
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Permission
 * @method listByParams(array $params) 获取所有权限列表
 * @method addByParams(array $params) 创建权限
 * @method deleteByParams(array $params) 删除权限
 * @method getStaffsByPermissionByParams(array $params) 根据权限获取拥有该权限的所有员工
 */
class Permission {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Permission";

    /**
     * 获取所有权限列表
     * @return  mixed
    */
    public static function list () {
        return RpcClass::getClass(self::$serviceName, self::$className)->list();
    }

    /**
     * 创建权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function add (int $staff_id, string $name, string $title, string $desc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["staff_id" => $staff_id, "name" => $name, "title" => $title, "desc" => $desc]);
    }

    /**
     * 删除权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 根据权限获取拥有该权限的所有员工
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffsByPermission (int $permission_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffsByPermission(["permission_id" => $permission_id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}