<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-21 11:46:21
 */
namespace Mainto\Bridge\Invokes\Business\Manager;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Tool
 * @method editOutShootPerformanceRealMoneyByParams(array $params) 外拍订单补差价异常处理：原因确认业绩前端跟后端保留位数不一致产生的资金问题
 * @method editContractRemainMoneyByParams(array $params) 编辑合同剩余金额
 * @method checkBillsWithoutOrderForZhaoShangByParams(array $params) 核对招商bill
 * @method cancelOrderByParams(array $params) 工具：取消订单仅business开发用
 * @method editOutShootPerformanceByParams(array $params) 外拍订单信息修改
 * @method editWhiteListDetailsByParams(array $params) 修改白名单发送消息状态（因为敏感词汇经常发送失败）
 * @method sendChangeDeliveryCertificationMsgByParams(array $params) 交付认证发送链接地址
 * @method changeDeliveryCertificationMsgByParams(array $params) 更改交付认证信息,防止邮箱或者手机号那个出问题了
 */
class Tool {
    private static string $serviceName = "Business";

    private static string $className = "Manager\\Tool";

    /**
     * 外拍订单补差价异常处理：原因确认业绩前端跟后端保留位数不一致产生的资金问题
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editOutShootPerformanceRealMoney (string $orderNo, float $realMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOutShootPerformanceRealMoney(["orderNo" => $orderNo, "realMoney" => $realMoney]);
    }

    /**
     * 编辑合同剩余金额
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editContractRemainMoney (string $contractNo, float $changeMoney) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editContractRemainMoney(["contractNo" => $contractNo, "changeMoney" => $changeMoney]);
    }

    /**
     * 核对招商bill
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkBillsWithoutOrderForZhaoShang (array $bankAccountFluentNums) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkBillsWithoutOrderForZhaoShang(["bankAccountFluentNums" => $bankAccountFluentNums]);
    }

    /**
     * 工具：取消订单仅business开发用
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelOrder (int $orderId, string $reason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderId" => $orderId, "reason" => $reason]);
    }

    /**
     * 外拍订单信息修改
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editOutShootPerformance (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editOutShootPerformance(["orderNo" => $orderNo]);
    }

    /**
     * 修改白名单发送消息状态（因为敏感词汇经常发送失败）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editWhiteListDetails (string $isSend, array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editWhiteListDetails(["isSend" => $isSend, "ids" => $ids]);
    }

    /**
     * 交付认证发送链接地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendChangeDeliveryCertificationMsg (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendChangeDeliveryCertificationMsg(["orderId" => $orderId]);
    }

    /**
     * 更改交付认证信息,防止邮箱或者手机号那个出问题了
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeDeliveryCertificationMsg (int $orderId, int $isCustomizedPhysicalCard, int $deliveryCertificationType, string $deliveryCertificationValue) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeDeliveryCertificationMsg(["orderId" => $orderId, "isCustomizedPhysicalCard" => $isCustomizedPhysicalCard, "deliveryCertificationType" => $deliveryCertificationType, "deliveryCertificationValue" => $deliveryCertificationValue]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}